/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.ar.CommonServiceAnalysisRoutine;
import com.ibm.hwmca.xfw.pa.event.CommonServiceAREvent;
import com.ibm.hwmca.xfw.pa.fedc.FEDCFileDescriptor;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CommonSystemAnalysisRoutine
extends CommonServiceAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "XPACSYAT";
    private static final String TRACE_MASKF = "XPACSYAF";
    private static final String TRACE_MASKD = "XPACSYAD";

    public CommonSystemAnalysisRoutine() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKD, "--> analyze()");
        CommonServiceAREvent ourEvent = (CommonServiceAREvent)event;
        String poolId = ourEvent.getIncidentPoolId();
        IncidentPool thePool = CommonSystemAnalysisRoutine.getAnalyzingIncidentPool(poolId);
        if (thePool == null) {
            Trace.trace(TRACE_MASKT, "<-- analyze(): no pool to analyze");
            return;
        }
        if (thePool.size() == 0) {
            Trace.trace(TRACE_MASKD, "no incidents in the pool");
        } else if (thePool.size() == 1) {
            Trace.trace(TRACE_MASKD, "only one incident in the pool");
            CommonServiceIncident topInc = (CommonServiceIncident)thePool.iterator().next();
            Trace.trace(TRACE_MASKD, "top (priority=" + topInc.getPriority() + ",refcode=" + topInc.getProblem().getRefcode() + ")");
        } else {
            List sortedList = this.sortIncidentPool(thePool);
            CommonServiceIncident topInc = (CommonServiceIncident)sortedList.get(0);
            Trace.trace(TRACE_MASKD, "top incident after sorting (priority=" + topInc.getPriority() + ",refcode=" + topInc.getProblem().getRefcode() + ")");
            this.swapTop(sortedList);
            this.associateFiles(sortedList);
            this.associateProblems(sortedList, thePool);
        }
        Trace.trace(TRACE_MASKD, "<-- analyze()");
    }

    protected void swapTop(List sortedList) {
        CommonServiceIncident topIncident = (CommonServiceIncident)sortedList.get(0);
        int swapIndex = 0;
        boolean swapIt = false;
        int i = 1;
        while (i < sortedList.size()) {
            swapIt = topIncident.swap((CommonServiceIncident)sortedList.get(i));
            if (swapIt) {
                swapIndex = i;
                break;
            }
            ++i;
        }
        if (swapIndex > 0) {
            CommonServiceIncident tempIncident = (CommonServiceIncident)sortedList.get(swapIndex);
            sortedList.set(0, tempIncident);
            sortedList.set(swapIndex, topIncident);
            Trace.trace(TRACE_MASKD, "swapped incidents");
            Trace.trace(TRACE_MASKD, "old top (priority=" + topIncident.getPriority() + ",refcode=" + topIncident.getProblem().getRefcode() + ")");
            Trace.trace(TRACE_MASKD, "new top (priority=" + tempIncident.getPriority() + ",refcode=" + tempIncident.getProblem().getRefcode() + ")");
        }
    }

    protected void associateFiles(List sortedList) {
        ArrayList callHomeFileList = new ArrayList();
        CommonServiceIncident anIncident = null;
        int i = 0;
        while (i < sortedList.size()) {
            anIncident = (CommonServiceIncident)sortedList.get(i);
            List associateFileList = anIncident.getAssociateFileList();
            if (associateFileList != null) {
                callHomeFileList.addAll(anIncident.getAssociateFileList());
            }
            ++i;
        }
        HashMap map = new HashMap();
        Iterator listIt = callHomeFileList.iterator();
        Object element = null;
        while (listIt.hasNext()) {
            element = listIt.next();
            if (!(element instanceof FEDCFileDescriptor)) continue;
            map.put(((FEDCFileDescriptor)element).name, element);
        }
        Trace.trace(TRACE_MASKD, "the final associateFile list is");
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            Trace.trace(TRACE_MASKD, "element is [" + it.next() + "]");
        }
        ((CommonServiceIncident)sortedList.get(0)).getProblem().addAssociatedFile(new ArrayList(map.values()));
    }

    protected void associateProblems(List sortedList, IncidentPool thePool) {
        CommonServiceIncident topIncident = (CommonServiceIncident)sortedList.get(0);
        CommonProblem topProblem = topIncident.getProblem();
        Iterator sortedIter = sortedList.iterator();
        sortedIter.next();
        CommonServiceIncident associateIncident = null;
        boolean isAssociate = false;
        while (sortedIter.hasNext()) {
            associateIncident = (CommonServiceIncident)sortedIter.next();
            isAssociate = topIncident.isAssociate(associateIncident);
            if (isAssociate) {
                topProblem.getAssociates().add(associateIncident.getProblem().getUniqueKey());
                associateIncident.getProblem().setAssociateOf(topProblem.getUniqueKey());
                associateIncident.getProblem().addAssociatedFile(topProblem.getAssociatedFileList());
                continue;
            }
            Trace.trace(TRACE_MASKD, "removing non-associate problem (priority=" + associateIncident.getPriority() + ",refcode=" + associateIncident.getProblem().getRefcode() + ")");
            thePool.remove(associateIncident);
            sortedIter.remove();
            topProblem.addSecondaryDataEvent(associateIncident.getProblem().getPrimaryDataEvent());
        }
    }
}

